/**************************************************************************
MODULE:    XSDO
CONTAINS:  CANopenIA extended SDO functionality
COPYRIGHT: Embedded Systems Academy, Inc. 2008-2017.
DISCLAIM:  Read and understand our disclaimer before using this code!
           www.esacademy.com/disclaim.htm
           This software was written in accordance to the guidelines at
           www.esacademy.com/software/softwarestyleguide.pdf
LICENSE:   Free to use with licensed CANopenIA chips, modules or devices
           like CANgineBerry, CANgineXXX and 447izer
VERSION:   1.10, EmSA 10-NOV-17
           $LastChangedDate: 2022-11-16 21:08:56 +0100 (Mi, 16 Nov 2022) $
           $LastChangedRevision: 5337 $
***************************************************************************/ 

#ifndef _XSDO_H
#define _XSDO_H

#include "global.h"

#define USE_EXTENDED_SDO 1
#define NR_OF_SDOSERVER 17


/**************************************************************************
DEFINES FOR ACCESS TYPE TO OD ENRIES
Readable, Writable, Read-Mapable, Write-Mapable, Call-Back
**************************************************************************/
#define ODRD 0x10
#define ODWR 0x20
#define RMAP 0x40
#define WMAP 0x80
#define CALB 0x08


/**************************************************************************
DOES:    Performs initialization
**************************************************************************/
extern void XSDO_Init(
  void
);

/**************************************************************************
DOES:    Process SDO Segmented Requests to generic OD entries
RETURNS: 0x00 Nothing was done
0x01 OK, handled, response generated
0x02 Abort, SDO Abort was generated
**************************************************************************/
extern uint8_t XSDO_HandleExtended(
  uint8_t *pReqBUF,                                  // Pointer to 8 data bytes with SDO data from request
  CAN_MSG *pResCAN,                                    // Pointer to SDO response
  uint8_t SDOServer                                  // Number of SDO Server (1 to NR_OF_SDOSERVER)
);


#endif // _XSDO_H
/**************************************************************************
END OF FILE
**************************************************************************/
